<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\Auth\VerificationController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\VehicleController;
use App\Http\Controllers\DocusignController;
use App\Http\Controllers\ModelController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/ 



Route::get('login', [LoginController::class,'showLoginForm'])->name('login');
Route::post('login', [LoginController::class,'login']);
Route::post('register', [RegisterController::class,'register']);
Route::get('/saveotp',  [RegisterController::class,'saveotp'])->name('otp.save');
Route::get('/auth/google', [GoogleController::class, 'redirectToGoogle']);
Route::get('auth/google/callback', [GoogleController::class, 'handleGoogleCallback']);

Route::get('password/forget',  function () { 
	return view('pages.forgot-password'); 
})->name('password.forget');
Route::post('password/email', [ForgotPasswordController::class,'sendResetLinkEmail'])->name('password.email');
Route::get('password/reset/{token}', [ResetPasswordController::class,'showResetForm'])->name('password.reset');
Route::post('password/reset', [ResetPasswordController::class,'reset'])->name('password.update');

Route::group(['middleware' => ['auth']], function() {
Route::group(['middleware' => ['verified']], function() {
Route::get('/dashboard', [DashboardController::class,'index'])->name('dashboard');
});
});




Route::group(['middleware' => 'auth'], function(){

	/**
    * Verification Routes
    */
    Route::get('/email/verify', [VerificationController::class,'show'])->name('verification.notice');
    Route::get('/email/verify/{id}/{hash}', [VerificationController::class,'verify'])->name('verification.verify')->middleware(['signed']);
    Route::post('/email/resend', [VerificationController::class,'resend'])->name('verification.resend');
	// logout route
	Route::get('/logout', [LoginController::class,'logout']);
	Route::get('/clear-cache', [HomeController::class,'clearCache']);

	
/* model routes start */

Route::get('/autocompletesearch', [ModelController::class,'autocompletesearch'])->name('autocompletesearch');
Route::post('/updatemodel', [ModelController::class,'updatemodel'])->name('updatemodel');
Route::resource('models', '\App\Http\Controllers\ModelController');
/* model routes start */

/* vehicle routes start */
Route::get('docusign',[DocusignController::class, 'index'])->name('docusign');
Route::get('connect-docusign',[DocusignController::class, 'connectDocusign'])->name('connect.docusign');
Route::get('docusign/callback',[DocusignController::class,'callback'])->name('docusign.callback');
Route::get('sign-document',[DocusignController::class,'signDocument'])->name('docusign.sign');



Route::get('getmodel', [VehicleController::class,'getmodel'])->name('getmodel');
Route::get('vehiclepdf/{id}', [VehicleController::class,'vehiclepdf'])->name('vehiclepdf');

Route::put('updateprice/{id}', [VehicleController::class,'updateprice'])->name('updateprice');

Route::get('vehicleprice/{id}', [VehicleController::class,'vehicleprice'])->name('vehicleprice');

	Route::get('/getvehicle', [VehicleController::class,'getvehicleList']);

    Route::resource('vehicle', '\App\Http\Controllers\VehicleController');

/* vehicle routes end */



/* user routes start */
	//only those have manage_user permission will get access
	//Route::group(['middleware' => 'can:manage_user'], function(){
    	Route::get('/profile', [UserController::class,'profile'])->name('profile');
		Route::get('usersearch', [UserController::class,'usersearch'])->name('usersearch');
		Route::get('/users', [UserController::class,'index']);
		Route::get('/user/get-list', [UserController::class,'getUserList']);
		Route::get('/user/create', [UserController::class,'create']);
		Route::post('/user/create', [UserController::class,'store'])->name('create-user');
		Route::get('/user/{id}', [UserController::class,'edit']);
		Route::post('/user/update', [UserController::class,'update']);
		Route::post('/updateuser', [UserController::class,'updateuser']);
		Route::get('/user/delete/{id}', [UserController::class,'delete']);
	//});

/* user routes end */


/* role routes start */
	//only those have manage_role permission will get access
	//Route::group(['middleware' => 'can:manage_role|manage_user'], function(){
		
		Route::get('rolesearch', [RolesController::class,'rolesearch'])->name('rolesearch');
		Route::get('/roles', [RolesController::class,'index']);
		Route::get('/role/get-list', [RolesController::class,'getRoleList']);
		Route::post('/role/create', [RolesController::class,'create']);
		Route::get('/role/edit/{id}', [RolesController::class,'edit']);
		Route::post('/role/update', [RolesController::class,'update']);
		Route::get('/role/delete/{id}', [RolesController::class,'delete']);
	//});
/* role routes start */

/* permission routes start */

	//only those have manage_permission permission will get access
	//Route::group(['middleware' => 'can:manage_permission|manage_user'], function(){
		Route::get('permissionsearch', [PermissionController::class,'permissionsearch'])->name('permissionsearch');
		Route::get('/permission', [PermissionController::class,'index']);
		Route::get('/permission/get-list', [PermissionController::class,'getPermissionList']);
		Route::post('/permission/create', [PermissionController::class,'create']);
		Route::get('/permission/update', [PermissionController::class,'update']);
		Route::get('/permission/delete/{id}', [PermissionController::class,'delete']);
	//});

	// get permissions
	Route::get('get-role-permissions-badge', [PermissionController::class,'getPermissionBadgeByRole']);


	// permission examples
    Route::get('/permission-example', function () {
    	return view('permission-example'); 
    });
 
/* permission routes start */
   
	/*Route::get('/profile', function () { return view('pages.profile'); });*/
	
	
});



/* role routes start */
	//only those have manage_role permission will get access
	//Route::group(['middleware' => 'can:manage_role|manage_user'], function(){
		
		/*Route::get('rolesearch', [RolesController::class,'rolesearch'])->name('rolesearch');
		Route::get('/roles', [RolesController::class,'index']);
		Route::get('/role/get-list', [RolesController::class,'getRoleList']);
		Route::post('/role/create', [RolesController::class,'create']);
		Route::get('/role/edit/{id}', [RolesController::class,'edit']);
		Route::post('/role/update', [RolesController::class,'update']);
		Route::get('/role/delete/{id}', [RolesController::class,'delete']);*/
	//});
/* role routes start */

/* permission routes start */

	//only those have manage_permission permission will get access
	//Route::group(['middleware' => 'can:manage_permission|manage_user'], function(){
		/*Route::get('permissionsearch', [PermissionController::class,'permissionsearch'])->name('permissionsearch');
		Route::get('/permission', [PermissionController::class,'index']);
		Route::get('/permission/get-list', [PermissionController::class,'getPermissionList']);
		Route::post('/permission/create', [PermissionController::class,'create']);
		Route::get('/permission/update', [PermissionController::class,'update']);
		Route::get('/permission/delete/{id}', [PermissionController::class,'delete']);*/
	//});

Route::get('/register', function () { return view('auth.register'); });
Route::get('/form-advance', function () { return view('pages.form-advance'); });